<?php
function get_cluster_id_list( $argv ) {
	global $DTASCFG_XML_FILE ;

	$xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    $db_host     = chop( $xml-> db -> host ) ;
    $db_username = chop( $xml-> db -> username ) ;
    $db_password =       $xml-> db -> password ;
	
    try {
    
        # Request db connection
        $stepName = "RequestDbConnection" ;
        debug_print( "${stepName}: host='$db_host', dbname='dtasdb', user='$db_username'" ) ;
        
        $connection = pg_connect( "host=$db_host dbname=dtasdb user=$db_username password=$db_password" ) ;
        if( $connection == false ) {
            $msg = "${stepName}Fail" ;
            
            debug_print( "$msg" ) ;
            throw new Exception( "$msg" ) ;
        }
        debug_print( "${stepName}Pass" ) ;
        
        
        # get all available sc_id
        $stepName = "QueryScId" ;
        $sql = "SELECT sc_id FROM tb_sc_info" ;
        debug_print( "$stepName: sql='$sql'" ) ;
        
        $query_result = pg_query( $sql ) ;
        if( $query_result == false ) {
            $msg = "${stepName}Fail: msg='" . pg_last_error() . "'" ;

            debug_print( "$msg" ) ;
            throw new Exception( "$msg" ) ;
        }
        debug_print( "${stepName}Pass" ) ;
        
        
        # extract sc_id from sql result
        $stepName = "ExtractScIdFromSqlResult" ;
        debug_print( "$stepName" ) ;
        
        $raw_sc_id_list = pg_fetch_all_columns( $query_result, 0 ) ;
        if( count( $raw_sc_id_list ) == 0 ) {
            $msg = "${stepName}Fail: msg='No SandboxController is found'" ;
            
            debug_print( $msg ) ;
            throw new Exception( "$msg" ) ;
        }
        debug_print( "${stepName}Pass: sc_id='" . join( ",", $raw_sc_id_list ) . "'" ) ;
        
        
        pg_close( $connection ) ;

        
        # filter sc_id
        $stepName = "FilterScId" ;
        debug_print( "$stepName" ) ;
        
        $sc_id_array = array() ;
        foreach( $raw_sc_id_list as $sc_id ) {
            if( $sc_id == "0" ) {
                debug_print( "${stepName}: $sc_id is filtered" ) ;
                continue ;
            }
            
            array_push( $sc_id_array, $sc_id ) ;
        }
        debug_print( "${stepName}Pass: sc_id='" . join( ",", $sc_id_array ) . "'" ) ;
        
        
        # sort
        $stepName = "SortScId" ;
        debug_print( "$stepName" ) ;
        sort( $sc_id_array ) ;
        $sc_id_list = join( ",", $sc_id_array ) ;
        debug_print( "${stepName}Pass: sc_id='$sc_id_list'" ) ;
        
        
        # return
        echo $sc_id_list . "\n" ;
        exit( 0 ) ;
    }
    
    catch( Exception $e ) {
        $msg = "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() ;
        
        debug_print( "Exception caught: msg='$msg'" ) ;
        echo $msg . "\n" ;
        
        if( $connection !== false ) {
            pg_close( $connection ) ;
        }
        
        exit( 1 ) ;
    }
}

